<?php
namespace Concrete\Package\CsvImportEntries\Job;

use Concrete\Core\Job\Job;
use Concrete\Core\Support\Facade\Express;

class CsvImportEntries extends Job
{
    public function getJobName()
    {
        return t("CSVデータインポート");
    }

    public function getJobDescription()
    {
        return t("CSVファイル（ヘッダー有り）からExpressエンティティにデータを登録します。");
    }

    public function run()
    {
        $csvFile = DIR_BASE . "/application/files/csv/input.csv";
        $entityHandle = 'illust';

        $entity = Express::getObjectByHandle($entityHandle);

        if (($handle = fopen($csvFile, "r")) !== FALSE) {
            $count = 0;
            $headers = fgetcsv($handle, 10000, ",");

            while (($data = fgetcsv($handle, 10000, ",")) !== FALSE) {
                $entry = Express::buildEntry($entity);

                foreach ($headers as $index => $attributeHandle) {
                    if (isset($data[$index])) {
                        $entry->setAttribute($attributeHandle, $data[$index]);
                    }
                }

                $entry->save();
                $count++;
            }
            fclose($handle);
        }


        return t("CSV import completed. Total entries processed: $count");
    }
}
