<?php
namespace Concrete\Package\CleanupOldEntries;

use Concrete\Core\Package\Package;
use Concrete\Core\Job\Job;

class Controller extends Package
{
    protected $pkgHandle = 'cleanup_old_entries';
    protected $appVersionRequired = '8.5.0';
    protected $pkgVersion = '1.0.0';

    public function getPackageName()
    {
        return t('Cleanup Old Entries');
    }

    public function getPackageDescription()
    {
        return t('エクスプレスの廃止データを削除する');
    }

    public function install()
    {
        $pkg = parent::install();
        Job::installByPackage('cleanup_old_entries', $pkg);
    }
}
