<?php
namespace Concrete\Package\CleanupOldEntries\Job;

use Concrete\Core\Job\Job;
use Concrete\Core\Express\EntryList;
use Doctrine\ORM\EntityManagerInterface;

class CleanupOldEntries extends Job
{
    public function getJobName()
    {
        return t("Cleanup Old Express Entries");
    }

    public function getJobDescription()
    {
        return t("Deletes the oldest 100 Express entries using Doctrine.");
    }

    public function run()
    {
        error_log("ジョブ開始");

        $entityHandle = 'illust';
        $express = \Core::make('express');
        $entity = $express->getObjectByHandle($entityHandle);

        if (!$entity) {
            return t("Error: Express entity '{$entityHandle}' not found.");
        }

        $entryList = new EntryList($entity);
        $entryList->sortByDateAdded('asc');
        $entryList->getQueryObject()->setMaxResults(1000);
        $entries = $entryList->getResults();

        $count = count($entries);
        error_log("取得件数: {$count}");

        if ($count === 0) {
            return t("No entries found.");
        }

        $em = \Core::make(EntityManagerInterface::class);

        foreach ($entries as $entry) {
            $entryEntity = $em->find('Concrete\Core\Entity\Express\Entry', $entry->getID());
            if ($entryEntity) {
                $em->remove($entryEntity);
            }
        }

        $em->flush();

        error_log("削除完了: {$count} 件");
        return "{$count} entries deleted.";
    }
}
