<?php
namespace Concrete\Package\CleanupDuplicateEntries;

use Concrete\Core\Package\Package;
use Concrete\Core\Job\Job;

class Controller extends Package
{
    protected $pkgHandle = 'cleanup_duplicate_entries';
    protected $appVersionRequired = '8.5.0';
    protected $pkgVersion = '2.0.0';

    public function getPackageName()
    {
        return t('Cleanup Duplicate Entries');
    }

    public function getPackageDescription()
    {
        return t('エクスプレスの最新データを残し重複データを削除する');
    }

    public function install()
    {
        $pkg = parent::install();
        Job::installByPackage('cleanup_duplicate_entries', $pkg);
    }
}
