<?php
namespace Concrete\Package\CopyDescriptionToMeta;

use Concrete\Core\Package\Package;
use Concrete\Core\Job\Job;

class Controller extends Package
{
    protected $pkgHandle = 'copy_description_to_meta';
    protected $appVersionRequired = '8.5.0';
    protected $pkgVersion = '1.0.0';

    public function getPackageName()
    {
        return t('Copy Description To Meta');
    }

    public function getPackageDescription()
    {
        return t('Copies the description attribute to the meta_description attribute for all pages.');
    }

    public function install()
    {
        $pkg = parent::install();
        Job::installByPackage('copy_description_to_meta', $pkg);
    }
}
