<?php
namespace Concrete\Package\CopyDescriptionToMeta\Job;

use Concrete\Core\Job\Job;
use Concrete\Core\Page\PageList;
use Concrete\Core\Page\Page;

use Concrete\Core\Page\Collection\Version\Version;

class CopyDescriptionToMeta extends Job
{
    public function getJobName()
    {
        return t('Copy Description to Meta Description');
    }

    public function getJobDescription()
    {
        return t('Copies the description attribute to the meta_description attribute for all pages.');
    }

    public function run()
    {
        $pl = new PageList();
        $pl->ignorePermissions();

        $pages = $pl->getResults();
        $updated = 0;

        foreach ($pages as $page) {
            /** @var Page $page */
            $description = $page->getCollectionDescription();

            if ($description) {
                $meta = $page->getAttribute('meta_description');
                if ($meta !== $description) {
                    $page->setAttribute('meta_description', $description);
                    $updated++;
                }
            }
        }

        return t('%s pages updated.', $updated);
    }
}
